<?php
// Função para codificar os URLs das imagens
function codificarURL($url) {
    return base64_encode($url);
}

// Função para decodificar os URLs das imagens
function decodificarURL($urlCodificado) {
    return base64_decode($urlCodificado);
}

// Se um link oculto para imagem for acessado, redirecionar para a URL real
if (isset($_GET['img'])) {
    $url = decodificarURL($_GET['img']);
    header("Location: $url");
    exit;
}

// Função para gerar JavaScript para decodificação de imagens
function gerarScriptDecodificacao($imagens) {
    $script = "<script>\n";
    $script .= "document.addEventListener('DOMContentLoaded', function() {\n";
    foreach ($imagens as $id => $codificado) {
        $script .= "  document.getElementById('$id').src = atob('$codificado');\n";
    }
    $script .= "});\n";
    $script .= "</script>\n";
    return $script;
}

// Gerar um array para armazenar as imagens e seus IDs
$imagens = [];
$contadorImg = 0;

// Função para substituir src de img e adicionar ao array
function ocultarLinksDeImagensNoHTML($html) {
    global $imagens, $contadorImg;
    return preg_replace_callback(
        '/src=["\'](https:\/\/.*?)["\']/i',
        function($matches) use (&$imagens, &$contadorImg) {
            $urlCodificado = codificarURL($matches[1]);
            $idImagem = 'img' . $contadorImg++;
            $imagens[$idImagem] = $urlCodificado;
            return 'id="' . $idImagem . '" src="#"';
        },
        $html
    );
}

// Iniciar o buffer de saída
ob_start();

// Configurar o timezone
date_default_timezone_set('America/Sao_Paulo');

// Carregar o arquivo JSON da URL
$jsonUrl = 'https://MEUDOMINIO/jogos_do_dia.json';
$jsonData = file_get_contents($jsonUrl);
$jogos = json_decode($jsonData, true);

// Obter a data atual
$diaSemana = array(
    'Sunday' => 'Domingo',
    'Monday' => 'Segunda-feira',
    'Tuesday' => 'Quarta-feira',
    'Wednesday' => 'Quarta-feira',
    'Thursday' => 'Quinta-feira',
    'Friday' => 'Sexta-feira',
    'Saturday' => 'Sábado'
);
$meses = array(
    'January' => 'Janeiro',
    'February' => 'Fevereiro',
    'March' => 'Março',
    'April' => 'Abril',
    'May' => 'Maio',
    'June' => 'Junho',
    'July' => 'Julho',
    'August' => 'Agosto',
    'September' => 'Setembro',
    'October' => 'Outubro',
    'November' => 'Novembro',
    'December' => 'Dezembro'
);

$data = new DateTime();
$diaSemanaPort = $diaSemana[$data->format('l')];
$dia = $data->format('d');
$mesPort = $meses[$data->format('F')];
$dataAtual = "$diaSemanaPort, $dia de $mesPort";
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Jogos do Dia</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-image: url('https://i.imgur.com/RqlrW3E.jpg');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            padding: 20px;
            display: flex;
            flex-direction: column;
            align-items: center;
        }
        .logo {
            max-width: 300px;
            margin-bottom: 20px;
        }
        .jogos-container {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 20px;
            width: 100%;
            max-width: 1200px;
        }
        .jogo-card {
            background-color: rgba(255, 255, 255, 0.8);
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
            padding: 20px;
            text-align: center;
            display: flex;
            flex-direction: column;
            align-items: center;
        }
        .jogo-card h1 {
            font-size: 18px;
            color: #004080;
            margin-bottom: 15px;
        }
        .jogo-info {
            display: flex;
            align-items: center;
            justify-content: space-between;
            width: 100%;
            margin-bottom: 10px;
        }
        .time {
            display: flex;
            align-items: center;
            flex-direction: column;
        }
        .time img {
            width: 80px;
            height: auto;
            margin-bottom: 5px;
            object-fit: contain;
        }
        .time-nome {
            font-weight: bold;
            font-size: 16px;
            color: #333;
            text-align: center;
        }
        .vs-hora-container {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }
        .vs img {
            width: 140px;
            max-width: 100px;
            height: auto;
            object-fit: contain;
        }
        .hora {
            font-size: 20px;
            font-weight: bold;
            color: #28a745;
            text-align: center;
            margin-top: 5px;
        }
        .canal {
            display: flex;
            justify-content: center;
            margin-top: 10px;
        }
        .canal-box {
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 5px 10px;
            border: 1px solid #ccc;
            border-radius: 12px;
            background-color: white;
            color: black;
            font-weight: bold;
            min-width: 100px;
            height: 20px;
            margin: 0 5px;
        }
        .canal-box img {
            width: 25px;
            height: 25px;
            margin-right: 5px;
            object-fit: contain;
        }
        .transmissao {
            color: #d9534f;
            font-weight: bold;
            margin-top: 15px;
        }
    </style>
    <script>
        const jogos = <?php echo json_encode($jogos); ?>;
        let currentIndex = 0;

        function atualizarCards() {
            const cards = document.querySelectorAll('.jogo-card');
            for (let i = 0; i < cards.length; i++) {
                const card = cards[i];
                const jogo = jogos[(currentIndex + i) % jogos.length];
                card.innerHTML = `
                    <h1>Jogos do Dia - ${'<?php echo $dataAtual; ?>'}</h1>
                    <div class="jogo-info">
                        <div class="time">
                            <img src="${jogo.logo1}" alt="${jogo.time1} Logo">
                            <div class="time-nome">${jogo.time1}</div>
                        </div>
                        <div class="vs-hora-container">
                            <div class="vs">
                                <img src="https://i.imgur.com/WcT6FXq.png" alt="Versus">
                            </div>
                            <div class="hora">${jogo.hora}</div>
                        </div>
                        <div class="time">
                            <img src="${jogo.logo2}" alt="${jogo.time2} Logo">
                            <div class="time-nome">${jogo.time2}</div>
                        </div>
                    </div>
                    <div class="canal">
                        ${jogo.canal_logos.length > 0 ? jogo.canal_logos.map(canal => `
                            <div class="canal-box">
                                <img src="${canal.logo}" alt="${canal.nome} Logo">
                                <div>${canal.nome}</div>
                            </div>
                        `).join('') : '<div class="transmissao">Transmissão não disponível</div>'}
                    </div>
                `;
            }
            currentIndex = (currentIndex + 3) % jogos.length;
        }

        document.addEventListener('DOMContentLoaded', function() {
            atualizarCards();
            setInterval(atualizarCards, 5000); // Muda os cards a cada 5 segundos
        });
    </script>
</head>
<body>

<!-- Adicionando a logo no topo da página -->
<img src="https://i.imgur.com/ZkAc2hy.png" alt="Logo" class="logo">

<div class="jogos-container">
    <div class="jogo-card"></div>
    <div class="jogo-card"></div>
    <div class="jogo-card"></div>
</div>

</body>
</html>
